/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util.replace;

import com.aptana.core.IMap;
import com.aptana.core.util.StringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextPatternReplacer {
    private static final String CLOSE_GROUP = ")";
    private static final String OPEN_GROUP = "(";
    private static final String OR_OPERATOR = "|";
    private static final String GROUP_DELIMITER = ")|(";
    public static final IMap<String, String> REPLACE_WITH_NOTHING = new IMap<String, String>(){

        @Override
        public String map(String item) {
            return "";
        }
    };
    protected Map<String, IMap<String, String>> patternActions;
    private Pattern pattern;

    public void addPattern(String pattern) {
        this.addPattern(pattern, null);
    }

    public void addPattern(String pattern, IMap<String, String> action) {
        if (pattern != null) {
            if (this.patternActions == null) {
                this.patternActions = new LinkedHashMap<String, IMap<String, String>>();
            }
            if (!this.patternActions.containsKey(pattern)) {
                if (action == null) {
                    action = REPLACE_WITH_NOTHING;
                }
                this.patternActions.put(pattern, action);
                pattern = null;
            }
        }
    }

    public abstract IMap<String, String> getAction(Matcher var1);

    public Pattern getPattern() {
        String regexString;
        if (this.pattern == null && !StringUtil.isEmpty(regexString = this.getRegexString())) {
            this.pattern = Pattern.compile(regexString);
        }
        return this.pattern;
    }

    protected abstract String getRegexString();

    protected String getReplacementText(Matcher matcher) {
        IMap<String, String> action = this.getAction(matcher);
        if (action != null) {
            return action.map(matcher.group());
        }
        return matcher.group();
    }

    public String searchAndReplace(String text) {
        Pattern p;
        if (!StringUtil.isEmpty(text) && (p = this.getPattern()) != null) {
            Matcher m = p.matcher(text);
            StringBuffer buffer = new StringBuffer();
            while (m.find()) {
                String replacementText = this.getReplacementText(m);
                replacementText = replacementText.replaceAll("\\$", "\\\\\\$");
                m.appendReplacement(buffer, replacementText);
            }
            m.appendTail(buffer);
            return buffer.toString();
        }
        return text;
    }

    protected String wrapInGroups(Collection<String> items) {
        return StringUtil.concat(OPEN_GROUP, StringUtil.join(GROUP_DELIMITER, items), CLOSE_GROUP);
    }
}

